var slideIndex = 0;
var slides = d3.selectAll('.slide');
var totalSlides = slides.size();

function showSlide(n) {
  // wrap around to the beginning or end if we go beyond the range of slides
  slideIndex = (n + totalSlides) % totalSlides;

  // hide all slides
  slides.classed('active', false);

  // show the current slide
  d3.select('#slide' + (slideIndex + 1)).classed('active', true);

  // get the timing for the current slide
  var timing = parseInt(d3.select('#slide' + (slideIndex + 1)).attr('data-timing'));

  // set a timeout to transition to the next slide after the specified delay
  setTimeout(function() {
    showSlide(slideIndex + 1);
  }, timing);
}

// show the first slide by default
showSlide(0);

// add event listeners for the previous and next buttons
d3.select('#prevBtn').on('click', function() {
  showSlide(slideIndex - 1);
});

d3.select('#nextBtn').on('click', function() {
  showSlide(slideIndex + 1);
});
